/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import org.mozilla.classfile.ClassFileWriter;
import org.mozilla.javascript.ClassCache;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextAction;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.GeneratedClassLoader;
import org.mozilla.javascript.IdFunctionCall;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.NativeJavaClass;
import org.mozilla.javascript.NativeJavaMethod;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.ObjToIntMap;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.SecurityController;
import org.mozilla.javascript.SecurityUtilities;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.Wrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JavaAdapter
implements IdFunctionCall {
    private static final Object FTAG = "JavaAdapter";
    private static final int Id_JavaAdapter = 1;

    public static void init(Context cx, Scriptable scope, boolean sealed) {
        JavaAdapter obj = new JavaAdapter();
        IdFunctionObject ctor = new IdFunctionObject(obj, FTAG, 1, "JavaAdapter", 1, scope);
        ctor.markAsConstructor(null);
        if (sealed) {
            ctor.sealObject();
        }
        ctor.exportAsScopeProperty();
    }

    @Override
    public Object execIdCall(IdFunctionObject f2, Context cx, Scriptable scope, Scriptable thisObj, Object[] args2) {
        if (f2.hasTag(FTAG) && f2.methodId() == 1) {
            return JavaAdapter.js_createAdapter(cx, scope, args2);
        }
        throw f2.unknown();
    }

    public static Object convertResult(Object result2, Class<?> c) {
        if (result2 == Undefined.instance && c != ScriptRuntime.ObjectClass && c != ScriptRuntime.StringClass) {
            return null;
        }
        return Context.jsToJava(result2, c);
    }

    public static Scriptable createAdapterWrapper(Scriptable obj, Object adapter) {
        Scriptable scope = ScriptableObject.getTopLevelScope(obj);
        NativeJavaObject res = new NativeJavaObject(scope, adapter, null, true);
        res.setPrototype(obj);
        return res;
    }

    public static Object getAdapterSelf(Class<?> adapterClass, Object adapter) throws NoSuchFieldException, IllegalAccessException {
        Field self2 = adapterClass.getDeclaredField("self");
        return self2.get(adapter);
    }

    static Object js_createAdapter(Context cx, Scriptable scope, Object[] args2) {
        Object arg;
        int classCount;
        int N = args2.length;
        if (N == 0) {
            throw ScriptRuntime.typeError0("msg.adapter.zero.args");
        }
        for (classCount = 0; classCount < N - 1 && !((arg = args2[classCount]) instanceof NativeObject); ++classCount) {
            if (arg instanceof NativeJavaClass) continue;
            throw ScriptRuntime.typeError2("msg.not.java.class.arg", String.valueOf(classCount), ScriptRuntime.toString(arg));
        }
        Class<?> superClass = null;
        Class[] intfs = new Class[classCount];
        int interfaceCount = 0;
        for (int i = 0; i < classCount; ++i) {
            Class<?> c = ((NativeJavaClass)args2[i]).getClassObject();
            if (!c.isInterface()) {
                if (superClass != null) {
                    throw ScriptRuntime.typeError2("msg.only.one.super", superClass.getName(), c.getName());
                }
                superClass = c;
                continue;
            }
            intfs[interfaceCount++] = c;
        }
        if (superClass == null) {
            superClass = ScriptRuntime.ObjectClass;
        }
        Class[] interfaces2 = new Class[interfaceCount];
        System.arraycopy(intfs, 0, interfaces2, 0, interfaceCount);
        Scriptable obj = ScriptableObject.ensureScriptable(args2[classCount]);
        Class<?> adapterClass = JavaAdapter.getAdapterClass(scope, superClass, interfaces2, obj);
        int argsCount = N - classCount - 1;
        try {
            Object unwrapped;
            Object adapter;
            if (argsCount > 0) {
                Object[] ctorArgs = new Object[argsCount + 2];
                ctorArgs[0] = obj;
                ctorArgs[1] = cx.getFactory();
                System.arraycopy(args2, classCount + 1, ctorArgs, 2, argsCount);
                NativeJavaClass classWrapper = new NativeJavaClass(scope, adapterClass, true);
                NativeJavaMethod ctors = classWrapper.members.ctors;
                int index2 = ctors.findCachedFunction(cx, ctorArgs);
                if (index2 < 0) {
                    String sig2 = NativeJavaMethod.scriptSignature(args2);
                    throw Context.reportRuntimeError2("msg.no.java.ctor", adapterClass.getName(), sig2);
                }
                adapter = NativeJavaClass.constructInternal(ctorArgs, ctors.methods[index2]);
            } else {
                Class[] ctorParms = new Class[]{ScriptRuntime.ScriptableClass, ScriptRuntime.ContextFactoryClass};
                Object[] ctorArgs = new Object[]{obj, cx.getFactory()};
                adapter = adapterClass.getConstructor(ctorParms).newInstance(ctorArgs);
            }
            Object self2 = JavaAdapter.getAdapterSelf(adapterClass, adapter);
            if (self2 instanceof Wrapper && (unwrapped = ((Wrapper)self2).unwrap()) instanceof Scriptable) {
                if (unwrapped instanceof ScriptableObject) {
                    ScriptRuntime.setObjectProtoAndParent((ScriptableObject)unwrapped, scope);
                }
                return unwrapped;
            }
            return self2;
        }
        catch (Exception ex) {
            throw Context.throwAsScriptRuntimeEx(ex);
        }
    }

    public static void writeAdapterObject(Object javaObject, ObjectOutputStream out) throws IOException {
        Class<?> cl = javaObject.getClass();
        out.writeObject(cl.getSuperclass().getName());
        Class<?>[] interfaces2 = cl.getInterfaces();
        String[] interfaceNames = new String[interfaces2.length];
        for (int i = 0; i < interfaces2.length; ++i) {
            interfaceNames[i] = interfaces2[i].getName();
        }
        out.writeObject(interfaceNames);
        try {
            Object delegee = cl.getField("delegee").get(javaObject);
            out.writeObject(delegee);
            return;
        }
        catch (IllegalAccessException e) {
        }
        catch (NoSuchFieldException e) {
            // empty catch block
        }
        throw new IOException();
    }

    public static Object readAdapterObject(Scriptable self2, ObjectInputStream in) throws IOException, ClassNotFoundException {
        Context cx = Context.getCurrentContext();
        ContextFactory factory = cx != null ? cx.getFactory() : null;
        Class<?> superClass = Class.forName((String)in.readObject());
        String[] interfaceNames = (String[])in.readObject();
        Class[] interfaces2 = new Class[interfaceNames.length];
        for (int i = 0; i < interfaceNames.length; ++i) {
            interfaces2[i] = Class.forName(interfaceNames[i]);
        }
        Scriptable delegee = (Scriptable)in.readObject();
        Class<?> adapterClass = JavaAdapter.getAdapterClass(self2, superClass, interfaces2, delegee);
        Class[] ctorParms = new Class[]{ScriptRuntime.ContextFactoryClass, ScriptRuntime.ScriptableClass, ScriptRuntime.ScriptableClass};
        Object[] ctorArgs = new Object[]{factory, delegee, self2};
        try {
            return adapterClass.getConstructor(ctorParms).newInstance(ctorArgs);
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException e) {
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        throw new ClassNotFoundException("adapter");
    }

    private static ObjToIntMap getObjectFunctionNames(Scriptable obj) {
        Object[] ids = ScriptableObject.getPropertyIds(obj);
        ObjToIntMap map2 = new ObjToIntMap(ids.length);
        for (int i = 0; i != ids.length; ++i) {
            String id;
            Object value2;
            if (!(ids[i] instanceof String) || !((value2 = ScriptableObject.getProperty(obj, id = (String)ids[i])) instanceof Function)) continue;
            Function f2 = (Function)value2;
            int length = ScriptRuntime.toInt32(ScriptableObject.getProperty((Scriptable)f2, "length"));
            if (length < 0) {
                length = 0;
            }
            map2.put(id, length);
        }
        return map2;
    }

    private static Class<?> getAdapterClass(Scriptable scope, Class<?> superClass, Class<?>[] interfaces2, Scriptable obj) {
        ObjToIntMap names;
        JavaAdapterSignature sig2;
        ClassCache cache = ClassCache.get(scope);
        Map<JavaAdapterSignature, Class<?>> generated = cache.getInterfaceAdapterCacheMap();
        Class<?> adapterClass = generated.get(sig2 = new JavaAdapterSignature(superClass, interfaces2, names = JavaAdapter.getObjectFunctionNames(obj)));
        if (adapterClass == null) {
            String adapterName = "adapter" + cache.newClassSerialNumber();
            byte[] code2 = JavaAdapter.createAdapterCode(names, adapterName, superClass, interfaces2, null);
            adapterClass = JavaAdapter.loadAdapterClass(adapterName, code2);
            if (cache.isCachingEnabled()) {
                generated.put(sig2, adapterClass);
            }
        }
        return adapterClass;
    }

    public static byte[] createAdapterCode(ObjToIntMap functionNames, String adapterName, Class<?> superClass, Class<?>[] interfaces2, String scriptClassName) {
        String methodKey;
        String methodSignature;
        Class<?>[] argTypes;
        String methodName;
        Constructor<?>[] ctors;
        ClassFileWriter cfw = new ClassFileWriter(adapterName, superClass.getName(), "<adapter>");
        cfw.addField("factory", "Lorg/mozilla/javascript/ContextFactory;", (short)17);
        cfw.addField("delegee", "Lorg/mozilla/javascript/Scriptable;", (short)17);
        cfw.addField("self", "Lorg/mozilla/javascript/Scriptable;", (short)17);
        int interfacesCount = interfaces2 == null ? 0 : interfaces2.length;
        for (int i = 0; i < interfacesCount; ++i) {
            if (interfaces2[i] == null) continue;
            cfw.addInterface(interfaces2[i].getName());
        }
        String superName = superClass.getName().replace('.', '/');
        for (Constructor<?> ctor : ctors = superClass.getConstructors()) {
            JavaAdapter.generateCtor(cfw, adapterName, superName, ctor);
        }
        JavaAdapter.generateSerialCtor(cfw, adapterName, superName);
        if (scriptClassName != null) {
            JavaAdapter.generateEmptyCtor(cfw, adapterName, superName, scriptClassName);
        }
        ObjToIntMap generatedOverrides = new ObjToIntMap();
        ObjToIntMap generatedMethods = new ObjToIntMap();
        for (int i = 0; i < interfacesCount; ++i) {
            Method[] methods2 = interfaces2[i].getMethods();
            for (int j = 0; j < methods2.length; ++j) {
                Method method2 = methods2[j];
                int mods = method2.getModifiers();
                if (Modifier.isStatic(mods) || Modifier.isFinal(mods)) continue;
                methodName = method2.getName();
                argTypes = method2.getParameterTypes();
                if (!functionNames.has(methodName)) {
                    try {
                        superClass.getMethod(methodName, argTypes);
                        continue;
                    }
                    catch (NoSuchMethodException e) {
                        // empty catch block
                    }
                }
                methodSignature = JavaAdapter.getMethodSignature(method2, argTypes);
                methodKey = methodName + methodSignature;
                if (generatedOverrides.has(methodKey)) continue;
                JavaAdapter.generateMethod(cfw, adapterName, methodName, argTypes, method2.getReturnType(), true);
                generatedOverrides.put(methodKey, 0);
                generatedMethods.put(methodName, 0);
            }
        }
        Method[] methods3 = JavaAdapter.getOverridableMethods(superClass);
        for (int j = 0; j < methods3.length; ++j) {
            Method method3 = methods3[j];
            int mods = method3.getModifiers();
            boolean isAbstractMethod = Modifier.isAbstract(mods);
            methodName = method3.getName();
            if (!isAbstractMethod && !functionNames.has(methodName)) continue;
            argTypes = method3.getParameterTypes();
            methodSignature = JavaAdapter.getMethodSignature(method3, argTypes);
            methodKey = methodName + methodSignature;
            if (generatedOverrides.has(methodKey)) continue;
            JavaAdapter.generateMethod(cfw, adapterName, methodName, argTypes, method3.getReturnType(), true);
            generatedOverrides.put(methodKey, 0);
            generatedMethods.put(methodName, 0);
            if (isAbstractMethod) continue;
            JavaAdapter.generateSuper(cfw, adapterName, superName, methodName, methodSignature, argTypes, method3.getReturnType());
        }
        ObjToIntMap.Iterator iter2 = new ObjToIntMap.Iterator(functionNames);
        iter2.start();
        while (!iter2.done()) {
            String functionName = (String)iter2.getKey();
            if (!generatedMethods.has(functionName)) {
                int length = iter2.getValue();
                Class[] parms = new Class[length];
                for (int k = 0; k < length; ++k) {
                    parms[k] = ScriptRuntime.ObjectClass;
                }
                JavaAdapter.generateMethod(cfw, adapterName, functionName, parms, ScriptRuntime.ObjectClass, false);
            }
            iter2.next();
        }
        return cfw.toByteArray();
    }

    static Method[] getOverridableMethods(Class<?> clazz2) {
        Class<?> c;
        ArrayList<Method> list2 = new ArrayList<Method>();
        HashSet<String> skip = new HashSet<String>();
        for (c = clazz2; c != null; c = c.getSuperclass()) {
            JavaAdapter.appendOverridableMethods(c, list2, skip);
        }
        for (c = clazz2; c != null; c = c.getSuperclass()) {
            for (Class<?> intf : c.getInterfaces()) {
                JavaAdapter.appendOverridableMethods(intf, list2, skip);
            }
        }
        return list2.toArray(new Method[list2.size()]);
    }

    private static void appendOverridableMethods(Class<?> c, ArrayList<Method> list2, HashSet<String> skip) {
        Method[] methods2 = c.getDeclaredMethods();
        for (int i = 0; i < methods2.length; ++i) {
            int mods;
            String methodKey = methods2[i].getName() + JavaAdapter.getMethodSignature(methods2[i], methods2[i].getParameterTypes());
            if (skip.contains(methodKey) || Modifier.isStatic(mods = methods2[i].getModifiers())) continue;
            if (Modifier.isFinal(mods)) {
                skip.add(methodKey);
                continue;
            }
            if (!Modifier.isPublic(mods) && !Modifier.isProtected(mods)) continue;
            list2.add(methods2[i]);
            skip.add(methodKey);
        }
    }

    static Class<?> loadAdapterClass(String className, byte[] classBytes2) {
        Object staticDomain;
        Class<?> domainClass = SecurityController.getStaticSecurityDomainClass();
        if (domainClass == CodeSource.class || domainClass == ProtectionDomain.class) {
            ProtectionDomain protectionDomain = SecurityUtilities.getScriptProtectionDomain();
            if (protectionDomain == null) {
                protectionDomain = JavaAdapter.class.getProtectionDomain();
            }
            staticDomain = domainClass == CodeSource.class ? (protectionDomain == null ? null : protectionDomain.getCodeSource()) : protectionDomain;
        } else {
            staticDomain = null;
        }
        GeneratedClassLoader loader = SecurityController.createLoader(null, staticDomain);
        Class<?> result2 = loader.defineClass(className, classBytes2);
        loader.linkClass(result2);
        return result2;
    }

    public static Function getFunction(Scriptable obj, String functionName) {
        Object x = ScriptableObject.getProperty(obj, functionName);
        if (x == Scriptable.NOT_FOUND) {
            return null;
        }
        if (!(x instanceof Function)) {
            throw ScriptRuntime.notFunctionError(x, functionName);
        }
        return (Function)x;
    }

    public static Object callMethod(ContextFactory factory, final Scriptable thisObj, final Function f2, final Object[] args2, final long argsToWrap) {
        if (f2 == null) {
            return Undefined.instance;
        }
        if (factory == null) {
            factory = ContextFactory.getGlobal();
        }
        final Scriptable scope = f2.getParentScope();
        if (argsToWrap == 0L) {
            return Context.call(factory, f2, scope, thisObj, args2);
        }
        Context cx = Context.getCurrentContext();
        if (cx != null) {
            return JavaAdapter.doCall(cx, scope, thisObj, f2, args2, argsToWrap);
        }
        return factory.call(new ContextAction(){

            public Object run(Context cx) {
                return JavaAdapter.doCall(cx, scope, thisObj, f2, args2, argsToWrap);
            }
        });
    }

    private static Object doCall(Context cx, Scriptable scope, Scriptable thisObj, Function f2, Object[] args2, long argsToWrap) {
        for (int i = 0; i != args2.length; ++i) {
            Object arg;
            if (0L == (argsToWrap & (long)(1 << i)) || (arg = args2[i]) instanceof Scriptable) continue;
            args2[i] = cx.getWrapFactory().wrap(cx, scope, arg, null);
        }
        return f2.call(cx, scope, thisObj, args2);
    }

    public static Scriptable runScript(final Script script) {
        return (Scriptable)ContextFactory.getGlobal().call(new ContextAction(){

            public Object run(Context cx) {
                ScriptableObject global = ScriptRuntime.getGlobal(cx);
                script.exec(cx, global);
                return global;
            }
        });
    }

    private static void generateCtor(ClassFileWriter cfw, String adapterName, String superName, Constructor<?> superCtor) {
        short locals2 = 3;
        Class<?>[] parameters = superCtor.getParameterTypes();
        if (parameters.length == 0) {
            cfw.startMethod("<init>", "(Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/ContextFactory;)V", (short)1);
            cfw.add(42);
            cfw.addInvoke(183, superName, "<init>", "()V");
        } else {
            StringBuilder sig2 = new StringBuilder("(Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/ContextFactory;");
            int marker = sig2.length();
            for (Class<?> c : parameters) {
                JavaAdapter.appendTypeString(sig2, c);
            }
            sig2.append(")V");
            cfw.startMethod("<init>", sig2.toString(), (short)1);
            cfw.add(42);
            short paramOffset = 3;
            for (Class<?> parameter : parameters) {
                paramOffset = (short)(paramOffset + JavaAdapter.generatePushParam(cfw, paramOffset, parameter));
            }
            locals2 = paramOffset;
            sig2.delete(1, marker);
            cfw.addInvoke(183, superName, "<init>", sig2.toString());
        }
        cfw.add(42);
        cfw.add(43);
        cfw.add(181, adapterName, "delegee", "Lorg/mozilla/javascript/Scriptable;");
        cfw.add(42);
        cfw.add(44);
        cfw.add(181, adapterName, "factory", "Lorg/mozilla/javascript/ContextFactory;");
        cfw.add(42);
        cfw.add(43);
        cfw.add(42);
        cfw.addInvoke(184, "org/mozilla/javascript/JavaAdapter", "createAdapterWrapper", "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/Object;)Lorg/mozilla/javascript/Scriptable;");
        cfw.add(181, adapterName, "self", "Lorg/mozilla/javascript/Scriptable;");
        cfw.add(177);
        cfw.stopMethod(locals2);
    }

    private static void generateSerialCtor(ClassFileWriter cfw, String adapterName, String superName) {
        cfw.startMethod("<init>", "(Lorg/mozilla/javascript/ContextFactory;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;)V", (short)1);
        cfw.add(42);
        cfw.addInvoke(183, superName, "<init>", "()V");
        cfw.add(42);
        cfw.add(43);
        cfw.add(181, adapterName, "factory", "Lorg/mozilla/javascript/ContextFactory;");
        cfw.add(42);
        cfw.add(44);
        cfw.add(181, adapterName, "delegee", "Lorg/mozilla/javascript/Scriptable;");
        cfw.add(42);
        cfw.add(45);
        cfw.add(181, adapterName, "self", "Lorg/mozilla/javascript/Scriptable;");
        cfw.add(177);
        cfw.stopMethod((short)4);
    }

    private static void generateEmptyCtor(ClassFileWriter cfw, String adapterName, String superName, String scriptClassName) {
        cfw.startMethod("<init>", "()V", (short)1);
        cfw.add(42);
        cfw.addInvoke(183, superName, "<init>", "()V");
        cfw.add(42);
        cfw.add(1);
        cfw.add(181, adapterName, "factory", "Lorg/mozilla/javascript/ContextFactory;");
        cfw.add(187, scriptClassName);
        cfw.add(89);
        cfw.addInvoke(183, scriptClassName, "<init>", "()V");
        cfw.addInvoke(184, "org/mozilla/javascript/JavaAdapter", "runScript", "(Lorg/mozilla/javascript/Script;)Lorg/mozilla/javascript/Scriptable;");
        cfw.add(76);
        cfw.add(42);
        cfw.add(43);
        cfw.add(181, adapterName, "delegee", "Lorg/mozilla/javascript/Scriptable;");
        cfw.add(42);
        cfw.add(43);
        cfw.add(42);
        cfw.addInvoke(184, "org/mozilla/javascript/JavaAdapter", "createAdapterWrapper", "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/Object;)Lorg/mozilla/javascript/Scriptable;");
        cfw.add(181, adapterName, "self", "Lorg/mozilla/javascript/Scriptable;");
        cfw.add(177);
        cfw.stopMethod((short)2);
    }

    static void generatePushWrappedArgs(ClassFileWriter cfw, Class<?>[] argTypes, int arrayLength) {
        cfw.addPush(arrayLength);
        cfw.add(189, "java/lang/Object");
        int paramOffset = 1;
        for (int i = 0; i != argTypes.length; ++i) {
            cfw.add(89);
            cfw.addPush(i);
            paramOffset += JavaAdapter.generateWrapArg(cfw, paramOffset, argTypes[i]);
            cfw.add(83);
        }
    }

    private static int generateWrapArg(ClassFileWriter cfw, int paramOffset, Class<?> argType) {
        int size2 = 1;
        if (!argType.isPrimitive()) {
            cfw.add(25, paramOffset);
        } else if (argType == Boolean.TYPE) {
            cfw.add(187, "java/lang/Boolean");
            cfw.add(89);
            cfw.add(21, paramOffset);
            cfw.addInvoke(183, "java/lang/Boolean", "<init>", "(Z)V");
        } else if (argType == Character.TYPE) {
            cfw.add(21, paramOffset);
            cfw.addInvoke(184, "java/lang/String", "valueOf", "(C)Ljava/lang/String;");
        } else {
            cfw.add(187, "java/lang/Double");
            cfw.add(89);
            String typeName = argType.getName();
            switch (typeName.charAt(0)) {
                case 'b': 
                case 'i': 
                case 's': {
                    cfw.add(21, paramOffset);
                    cfw.add(135);
                    break;
                }
                case 'l': {
                    cfw.add(22, paramOffset);
                    cfw.add(138);
                    size2 = 2;
                    break;
                }
                case 'f': {
                    cfw.add(23, paramOffset);
                    cfw.add(141);
                    break;
                }
                case 'd': {
                    cfw.add(24, paramOffset);
                    size2 = 2;
                }
            }
            cfw.addInvoke(183, "java/lang/Double", "<init>", "(D)V");
        }
        return size2;
    }

    static void generateReturnResult(ClassFileWriter cfw, Class<?> retType, boolean callConvertResult) {
        if (retType == Void.TYPE) {
            cfw.add(87);
            cfw.add(177);
        } else if (retType == Boolean.TYPE) {
            cfw.addInvoke(184, "org/mozilla/javascript/Context", "toBoolean", "(Ljava/lang/Object;)Z");
            cfw.add(172);
        } else if (retType == Character.TYPE) {
            cfw.addInvoke(184, "org/mozilla/javascript/Context", "toString", "(Ljava/lang/Object;)Ljava/lang/String;");
            cfw.add(3);
            cfw.addInvoke(182, "java/lang/String", "charAt", "(I)C");
            cfw.add(172);
        } else if (retType.isPrimitive()) {
            cfw.addInvoke(184, "org/mozilla/javascript/Context", "toNumber", "(Ljava/lang/Object;)D");
            String typeName = retType.getName();
            switch (typeName.charAt(0)) {
                case 'b': 
                case 'i': 
                case 's': {
                    cfw.add(142);
                    cfw.add(172);
                    break;
                }
                case 'l': {
                    cfw.add(143);
                    cfw.add(173);
                    break;
                }
                case 'f': {
                    cfw.add(144);
                    cfw.add(174);
                    break;
                }
                case 'd': {
                    cfw.add(175);
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected return type " + retType.toString());
                }
            }
        } else {
            String retTypeStr = retType.getName();
            if (callConvertResult) {
                cfw.addLoadConstant(retTypeStr);
                cfw.addInvoke(184, "java/lang/Class", "forName", "(Ljava/lang/String;)Ljava/lang/Class;");
                cfw.addInvoke(184, "org/mozilla/javascript/JavaAdapter", "convertResult", "(Ljava/lang/Object;Ljava/lang/Class;)Ljava/lang/Object;");
            }
            cfw.add(192, retTypeStr);
            cfw.add(176);
        }
    }

    private static void generateMethod(ClassFileWriter cfw, String genName, String methodName, Class<?>[] parms, Class<?> returnType, boolean convertResult) {
        StringBuilder sb = new StringBuilder();
        int paramsEnd = JavaAdapter.appendMethodSignature(parms, returnType, sb);
        String methodSignature = sb.toString();
        cfw.startMethod(methodName, methodSignature, (short)1);
        cfw.add(42);
        cfw.add(180, genName, "factory", "Lorg/mozilla/javascript/ContextFactory;");
        cfw.add(42);
        cfw.add(180, genName, "self", "Lorg/mozilla/javascript/Scriptable;");
        cfw.add(42);
        cfw.add(180, genName, "delegee", "Lorg/mozilla/javascript/Scriptable;");
        cfw.addPush(methodName);
        cfw.addInvoke(184, "org/mozilla/javascript/JavaAdapter", "getFunction", "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/String;)Lorg/mozilla/javascript/Function;");
        JavaAdapter.generatePushWrappedArgs(cfw, parms, parms.length);
        if (parms.length > 64) {
            throw Context.reportRuntimeError0("JavaAdapter can not subclass methods with more then 64 arguments.");
        }
        long convertionMask = 0L;
        for (int i = 0; i != parms.length; ++i) {
            if (parms[i].isPrimitive()) continue;
            convertionMask |= (long)(1 << i);
        }
        cfw.addPush(convertionMask);
        cfw.addInvoke(184, "org/mozilla/javascript/JavaAdapter", "callMethod", "(Lorg/mozilla/javascript/ContextFactory;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Function;[Ljava/lang/Object;J)Ljava/lang/Object;");
        JavaAdapter.generateReturnResult(cfw, returnType, convertResult);
        cfw.stopMethod((short)paramsEnd);
    }

    private static int generatePushParam(ClassFileWriter cfw, int paramOffset, Class<?> paramType) {
        if (!paramType.isPrimitive()) {
            cfw.addALoad(paramOffset);
            return 1;
        }
        String typeName = paramType.getName();
        switch (typeName.charAt(0)) {
            case 'b': 
            case 'c': 
            case 'i': 
            case 's': 
            case 'z': {
                cfw.addILoad(paramOffset);
                return 1;
            }
            case 'l': {
                cfw.addLLoad(paramOffset);
                return 2;
            }
            case 'f': {
                cfw.addFLoad(paramOffset);
                return 1;
            }
            case 'd': {
                cfw.addDLoad(paramOffset);
                return 2;
            }
        }
        throw Kit.codeBug();
    }

    private static void generatePopResult(ClassFileWriter cfw, Class<?> retType) {
        if (retType.isPrimitive()) {
            String typeName = retType.getName();
            switch (typeName.charAt(0)) {
                case 'b': 
                case 'c': 
                case 'i': 
                case 's': 
                case 'z': {
                    cfw.add(172);
                    break;
                }
                case 'l': {
                    cfw.add(173);
                    break;
                }
                case 'f': {
                    cfw.add(174);
                    break;
                }
                case 'd': {
                    cfw.add(175);
                }
            }
        } else {
            cfw.add(176);
        }
    }

    private static void generateSuper(ClassFileWriter cfw, String genName, String superName, String methodName, String methodSignature, Class<?>[] parms, Class<?> returnType) {
        cfw.startMethod("super$" + methodName, methodSignature, (short)1);
        cfw.add(25, 0);
        int paramOffset = 1;
        for (Class<?> parm : parms) {
            paramOffset += JavaAdapter.generatePushParam(cfw, paramOffset, parm);
        }
        cfw.addInvoke(183, superName, methodName, methodSignature);
        Class<?> retType = returnType;
        if (!retType.equals(Void.TYPE)) {
            JavaAdapter.generatePopResult(cfw, retType);
        } else {
            cfw.add(177);
        }
        cfw.stopMethod((short)(paramOffset + 1));
    }

    private static String getMethodSignature(Method method2, Class<?>[] argTypes) {
        StringBuilder sb = new StringBuilder();
        JavaAdapter.appendMethodSignature(argTypes, method2.getReturnType(), sb);
        return sb.toString();
    }

    static int appendMethodSignature(Class<?>[] argTypes, Class<?> returnType, StringBuilder sb) {
        sb.append('(');
        int firstLocal = 1 + argTypes.length;
        for (Class<?> type : argTypes) {
            JavaAdapter.appendTypeString(sb, type);
            if (type != Long.TYPE && type != Double.TYPE) continue;
            ++firstLocal;
        }
        sb.append(')');
        JavaAdapter.appendTypeString(sb, returnType);
        return firstLocal;
    }

    private static StringBuilder appendTypeString(StringBuilder sb, Class<?> type) {
        while (type.isArray()) {
            sb.append('[');
            type = type.getComponentType();
        }
        if (type.isPrimitive()) {
            char typeLetter;
            if (type == Boolean.TYPE) {
                typeLetter = 'Z';
            } else if (type == Long.TYPE) {
                typeLetter = 'J';
            } else {
                String typeName = type.getName();
                typeLetter = Character.toUpperCase(typeName.charAt(0));
            }
            sb.append(typeLetter);
        } else {
            sb.append('L');
            sb.append(type.getName().replace('.', '/'));
            sb.append(';');
        }
        return sb;
    }

    static int[] getArgsToConvert(Class<?>[] argTypes) {
        int count2 = 0;
        for (int i = 0; i != argTypes.length; ++i) {
            if (argTypes[i].isPrimitive()) continue;
            ++count2;
        }
        if (count2 == 0) {
            return null;
        }
        int[] array = new int[count2];
        count2 = 0;
        for (int i = 0; i != argTypes.length; ++i) {
            if (argTypes[i].isPrimitive()) continue;
            array[count2++] = i;
        }
        return array;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class JavaAdapterSignature {
        Class<?> superClass;
        Class<?>[] interfaces;
        ObjToIntMap names;

        JavaAdapterSignature(Class<?> superClass, Class<?>[] interfaces2, ObjToIntMap names) {
            this.superClass = superClass;
            this.interfaces = interfaces2;
            this.names = names;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof JavaAdapterSignature)) {
                return false;
            }
            JavaAdapterSignature sig2 = (JavaAdapterSignature)obj;
            if (this.superClass != sig2.superClass) {
                return false;
            }
            if (this.interfaces != sig2.interfaces) {
                if (this.interfaces.length != sig2.interfaces.length) {
                    return false;
                }
                for (int i = 0; i < this.interfaces.length; ++i) {
                    if (this.interfaces[i] == sig2.interfaces[i]) continue;
                    return false;
                }
            }
            if (this.names.size() != sig2.names.size()) {
                return false;
            }
            ObjToIntMap.Iterator iter2 = new ObjToIntMap.Iterator(this.names);
            iter2.start();
            while (!iter2.done()) {
                String name = (String)iter2.getKey();
                int arity = iter2.getValue();
                if (arity != sig2.names.get(name, arity + 1)) {
                    return false;
                }
                iter2.next();
            }
            return true;
        }

        public int hashCode() {
            return this.superClass.hashCode() + Arrays.hashCode(this.interfaces) ^ this.names.size();
        }
    }
}

